% Generate Example 8-1 in the book

clc
clear all
close all

%% get the FOUs from the IA; only return 9 words
[words,MFs,Cs]=getFOUsC8();

%% Construct the rulebase
subsetSurvey=[1 4 5 7 9]; %% indices of the five words used in the survey
MFs=MFs(subsetSurvey,:);

%% Compute the consequent FOUs and plot
conMFsC=zeros(length(subsetSurvey),9);
figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultaxesFontSize',10);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);

[YU,UU,YL,UL]=lwaPR(MFs(1:2,:),[33 33; 12 12],2);
subplot(651);
fill(MFs(1,[1:4 8:-1:5]),[0 1 1 0 0 MFs(1,[9 9]) 0],[0.9 0.9 0.9]);
hold on;
title('NVL','fontsize',10);
plot(MFs(1,[1:4 8:-1:5]),[0 1 1 0 0 MFs(1,[9 9]) 0]);
set(gca,'YTick',[]);
set(gca,'XTick',[]);
axis([0 10 0 1]);
subplot(652)
fill(MFs(2,[1:4 8:-1:5]),[0 1 1 0 0 MFs(2,[9 9]) 0],[0.9 0.9 0.9]);
hold on;
title('S','fontsize',10);
plot(MFs(2,[1:4 8:-1:5]),[0 1 1 0 0 MFs(2,[9 9]) 0]);
set(gca,'YTick',[]);
set(gca,'XTick',[]);
axis([0 10 0 1]);
subplot(653)
fill([YU YL(length(YL):-1:1)],[UU UL(length(UL):-1:1)],[0.9 0.9 0.9]);
hold on;
title('$\tilde{Y}^2$','Interpreter','latex','fontsize',10);
plot([YU YL(length(UL):-1:1)],[UU UL(length(UL):-1:1)]);
set(gca,'YTick',[]);
set(gca,'XTick',[]);
axis([0 10 0 1]);

saveas(gcf,'Fig8-2.eps');
